#!/system/xbin/bash

set -e
hour=0

if test -e /data/log-crawler-debug; then
    set -x
    exec 2>/data/log-crawler.log
fi

setprop ro.factory.psn $(dd if=$(echo /dev/block/platform/*/by-name/factory) count=14 bs=1 skip=5) || true

if test "$(getprop persist.smartisan.logs.enable)" = 0; then
    sleep 1
    log -t bhj "Make sure there are no logcat running"$(getprop | grep stopping)
    setprop persist.smartisan.logs.enable 0
fi&

if test "$(getprop persist.smartisan.devtest)" != 1; then
    exit 0
fi

# need change the owner for the partitions we want Scitd to write

    # chown root factory /dev/block/mmcblk0p18
    # chown root factory /dev/block/mmcblk0p19
    # chmod 0660 /dev/block/mmcblk0p18
    # chmod 0660 /dev/block/mmcblk0p19
    # lrwxrwxrwx root     root              1970-01-22 01:49 alterable -> /dev/block/mmcblk0p19
    # lrwxrwxrwx root     root              1970-01-22 01:49 factory -> /dev/block/mmcblk0p18

(
    for p in factory udisk alterable; do
        p=$(echo /dev/block/platform/*/by-name/$p)
        if test -b "$p"; then
            p=$(readlink -f "$p")
            chown root.factory "$p"
            chmod 0660 "$p"
        fi
    done
)&

if test -e /sdcard/adb-wifi.txt -o -e /data/adb-wifi.txt; then
    touch /data/adb-wifi.txt;
    if test "$(getprop service.adb.tcp.port)" != 5555 -a "$(getprop persist.smartisan.devtest)" = 1; then
        setprop service.adb.tcp.port 5555
        stop adbd
        start adbd
    fi
fi&

for x in $(seq 1 3); do
    break
    if test ! -e /system/usr/share/log-crawler/arm64/LogCrawler.odex ||
            test "$(stat -c %s /data/dalvik-cache/arm64/system@usr@share@log-crawler@LogCrawler.apk@classes.dex)" = 0; then
        rm /data/dalvik-cache/arm64/system@usr@share@log-crawler@LogCrawler.apk@classes.dex || true
        dalvikvm -cp /system/usr/share/log-crawler/LogCrawler.apk ExtractSwapDump || true
        chmod 644 /data/dalvik-cache/arm64/system@usr@share@log-crawler@LogCrawler.apk@classes.dex || true
    else
        break
    fi
done

if test "$(getprop persist.smartisan.swapdump)" = 1; then
    bash /etc/stcmd-scripts/enable-swap-dump&
else
    bash /etc/stcmd-scripts/disable-swap-dump&
fi

my_name=$(basename $0)
logwrapper scan-for-ramdump-panic.sh || true
rm -r /data/log-crawler/ -f || true
exit 0 # log-crawler should not work anymore.
# back up logs on start
logdir=/data/log-crawler/
if test "$(getprop persist.smartisan.devtest)" != 1; then
    mkdir -p /data/logs
    cd /data/logs
    scan-for-ramdump-panic.sh || true
    rm -r /data/log-crawler/
    exit 0
fi

for d in $(seq 1 100); do
    if test -d $logdir/logs.$d; then
        continue
    else
        break
    fi
done

function filter-out() {
    for x in "$@"; do
        if basename "$x" | grep -q -E -e '^system|^events|^radio'; then
            true;
        else
            echo "$x"
        fi
    done
}

function all-log-dirs() {
    local x;
    for x in $(seq 1 100); do
        if test -d $logdir/logs.$x; then
            echo $logdir/logs.$x;
        else
            break;
        fi;
    done
}

if test $d = 100; then
    tar czvf $logdir/log.tgz $(all-log-dirs)
    d=1
    rm -r $(all-log-dirs)
fi

log_boot_seq=$d
session_id=unknown
current_logdir=$logdir/logs.$d
mkdir -p $current_logdir
cd $current_logdir

backup-files() {
    local x;
    for x in "$@"; do
        if test ! -f "$x"; then
            log "$x is not a file"
            continue
        fi
        if echo "${x##*/}" | grep -q '^last_kmsg'; then
            log "do not backup last_kmsg: ${x##*/}"
            continue
        fi
        md5=$(md5sum "$x" | awk '{print $1}')
        if test -e .$md5; then
            continue
        fi
        touch .$md5

        target=$(basename $x)
        while test "${target:0:1}" = .; do
            target=${target:1}
        done

        if test "$target" = ""; then
            target=dots
        fi

        if test -e "$target" -o -e .uploaded/"$target"; then
            t=1;
            while true; do
                if test ! -e $t.$target -a ! -e $t.$target; then
                    break
                fi
                ((t++)) || true
            done
            target=$t.$target;
        fi
        cp $x ./$target
    done
}

backup-all-files() {
    # backup-files $(filter-out /data/logs/*)
    uptime > uptime.$hour
    ps -o pid,ppid,user,time,etime,comm > ps.$hour
    netcfg | grep wlan0 > wlan0-ip.txt || true
    top -n 1 > top.$hour

    dumpsys meminfo > meminfo.$hour ||
    awk -f /system/xbin/check-meminfo.awk /proc/*/smaps /proc/meminfo > meminfo.$hour || true
    cat /d/ion/heaps/system > ion.$hour || true
    local x;
    for x in /sys/devices/virtual/kgsl/kgsl/*; do if test -d $x; then continue; fi; echo -n "$x: "; cat $x; done > kgsl.$hour || true
    for x in /sys/class/power_supply/*batt*/*; do test -d $x && continue; echo $x:; cat $x; echo; done > battery.$hour || true
}

function log() {
    command log -t $my_name "$@"
}

function upload_logs() {

    wifi_mac=$(
        getprop ro.serialno
    )

    true_wifi_mac=$(
        netcfg | grep wlan0 | awk '{print $5}'
    )

    wifi_ip=$(
        netcfg | grep wlan0 | awk '{print $3}'
    )
    if test -z "$wifi_ip" -o "$wifi_ip" = 0.0.0.0/0; then
        log "Wifi not connected, do nothing."
        return 0
    fi

    logserver=$(getprop log.crawler.server)
    if test -z "$logserver"; then
        logserver=http://172.16.0.251
    fi
    upload_url=$logserver/cgi-bin/upload-logs.cgi

    logapk=$(
        if test -e /system/usr/share/log-crawler/LogCrawler.apk; then
            echo /system/usr/share/log-crawler/LogCrawler.apk
        else
            echo /data/PostFile-debug.apk # for test
        fi
    )
    phone_num=$(
        if test -e /sdcard/smartisan/my-phone-number.txt; then
            cat /sdcard/smartisan/my-phone-number.txt
        else
            echo unknown
        fi
    )

    dalvikvm -cp $logapk PostFile $upload_url session_id $session_id boot_seq $log_boot_seq log_seq "$(basename $PWD | sed 's/.*\.//')" phone_num "$phone_num" wifi_mac "$wifi_mac" true_wifi_mac "$true_wifi_mac" "$@"
}

function upload_pwd_logs() {
    local x;
    if ! ls * >/dev/null 2>&1; then # no files
        return 0;
    fi
    if upload_logs $(
            for x in $(filter-out *); do
                if test -f "$x"; then
                    echo $x @$x;
                fi
            done
        ) | tee /proc/self/fd/2 | grep 'Upload is complete!' > .upload.grep; then
        mkdir -p .uploaded
        for x in $(filter-out *); do
            if test -f "$x"; then
                mv $x .uploaded
            fi
        done
        session_id=$(cat .upload.grep | awk '{print $4}')
        session_id=${session_id:-unknown}
        return 0
    else
        return 1
    fi
}

function upload-old-logs() {
    if test $need_to_upload_old = false; then
        return 0;
    fi

    need_to_upload_old=not-sure
    local x;
    for x in $(seq 1 100); do
        if test $x = $log_boot_seq; then
            continue
        fi
        current_logdir=$logdir/logs.$x
        if test -d "$current_logdir"; then
            (
                cd $current_logdir
                if ls * >/dev/null 2>&1; then
                    upload_pwd_logs || need_to_upload_old=true
                fi
            )
        else
            break
        fi
    done
    if test $need_to_upload_old = not-sure; then
        need_to_upload_old=false
    fi
}

backup-all-files



getprop | grep build > build.txt
date > date.txt
cat /sys/pversion_info/* > pversion.txt || true
uname -a > uname.txt
dmesg > dmesg.txt

if test "$(getprop persist.smartisan.devtest)" != 1; then
    exit 0
fi

for x in $(seq 1 5); do # wait for wifi connection for 5 minutes
    wifi_ip=$(netcfg | grep wlan0 | awk '{print $3}')
    if test -z "$wifi_ip" -o "$wifi_ip" = 0.0.0.0/0; then
        log "wifi not connected, wait for it..."
        sleep 60;
    else
        break
    fi
done

upload_pwd_logs || true

need_to_upload_old=not-sure

upload-old-logs

while true; do
    ((hour++)) || true
    sleep 3600 || true
    if test $need_to_upload_old != false; then
        upload-old-logs
    fi
    backup-all-files
    upload_pwd_logs || true
done
