#!/system/bin/sh

## part 1, pre-install app
cd /system/media/app
var=`getprop persist.preinstalled 2>&1`
var2=`getprop persist.icon.preinstalled 2>&1`

#android shell script: check if preinstall is exist
if [ "$var" = "y" ]; then
    echo "don't need to copy preinstall files"
else
    # scan all apk files under system/media/app
    apklist="$(ls)"
    for apkfile in ${apklist}; do
        #copy all apk file to data/app
        cp ${apkfile} /data/app/${apkfile}
        # change the permission
        chown 1000:1000 /data/app/${apkfile}
        chmod 644 /data/app/${apkfile}
    done
    setprop persist.preinstalled  y
fi

if [ -d "/cache/app" ]; then
    cp /cache/app/* /data/app
    if [ -f "/data/app/Phonesky.apk" ]; then
        chown -R 1000:1000 /data/app
        chmod 644 -R /data/app/*.apk
        rm -rf /cache/app
    fi
fi

if [ ! -f  "/system/priv-app/GmsCore.apk" ]; then
    rm /data/app/GoogleCalendarSyncAdapter.apk
    rm /data/app/GoogleContactsSyncAdapter.apk
    rm /data/app/Phonesky.apk
    rm -rf /data/app/com.google.android.gms-1
    rm -rf /data/app/com.google.android.gms-2
    rm -rf /data/app/com.android.vending-1
    rm -rf /data/app/com.android.vending-2
fi

# part 2, pre-install icon
if [ "$var2" = "y" ]; then
    echo "don't need to copy pre-install icons"
else
    mkdir /data/system/icon
    chown 1000:1000 /data/system/icon
    chmod 775 /data/system/icon

    cd /system/media/icon
    pkglist="$(ls)"
    for pkg in ${pkglist}; do
        if [ ! -d /data/system/icon/${pkg} ]; then
            mkdir /data/system/icon/${pkg}
            chown 1000:1000 /data/system/icon/${pkg}
            chmod 775 /data/system/icon/${pkg}
            cd /system/media/icon/${pkg}
            filelist="$(ls)"
            for file in ${filelist}; do
                cp ${file} /data/system/icon/${pkg}/${file}
                chown 1000:1000 /data/system/icon/${pkg}/${file}
                chmod 644 /data/system/icon/${pkg}/${file}
            done
        fi
    done
    setprop persist.icon.preinstalled y
fi
