#!/system/bin/sh

priv_folder=/system/priv-app
permission_folder=/system/etc/permissions
framework_folder=/system/framework
lib_folder=/system/lib64
file1=GmsCore.apk
file2=GoogleLoginService.apk
file3=GoogleServicesFramework.apk
file4=com.google.android.maps.xml
file5=com.google.android.maps.jar
libs=(libAppDataSearch.so libappstreaming_jni.so libconscrypt_gmscore_jni.so libdirect-audio.so libgcastv2_base.so libgcastv2_support.so libgmscore.so libgms-ocrclient.so libjgcastservice.so libleveldbjni.so libNearbyApp.so libsslwrapper_jni.so libwearable-selector.so libWhisper.so)
bak_path=/cache/gms

MKDIR="toolbox mkdir"; CP="toolbox cp -p"; RM="toolbox rm"; CHMOD="toolbox chmod"

if [ "$1" = "backup" ]; then
  if [ -f "${priv_folder}/${file1}" ]; then
    if [ -d $bak_path ];then
      $RM -r $bak_path
    fi
    $MKDIR $bak_path
    $CP $priv_folder/$file1 $bak_path
    $CP $priv_folder/$file2 $bak_path
    $CP $priv_folder/$file3 $bak_path
    $CP $permission_folder/$file4 $bak_path
    $CP $framework_folder/$file5 $bak_path
    for var in ${libs[@]};do $CP $lib_folder/$var $bak_path;done
  fi
elif [ "$1" = "recover" ]; then
  if [ -d $bak_path ];then
    $CP $bak_path/$file1 $priv_folder
    $CP $bak_path/$file2 $priv_folder
    $CP $bak_path/$file3 $priv_folder
    $CP $bak_path/$file4 $permission_folder
    $CP $bak_path/$file5 $framework_folder
    for var in ${libs[@]};do $CP $bak_path/$var $lib_folder;done
    $RM -r $bak_path
  fi
fi
