#!/system/bin/sh
# Copyright (c) 2009-2013, The Linux Foundation. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of The Linux Foundation nor
#       the names of its contributors may be used to endorse or promote
#       products derived from this software without specific prior written
#       permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NON-INFRINGEMENT ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
# OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
# OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
# ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

#Read the arguments passed to the script

LOG_TAG="qcom-sensor"
LOG_NAME="${0}:"

loge ()
{
  /system/bin/log -t $LOG_TAG -p e "$LOG_NAME $@"
}

logi ()
{
  /system/bin/log -t $LOG_TAG -p i "$LOG_NAME $@"
}

logi "In qcom sensor shell Script"

# sensor type such as G-sensor , P/L-sensor, GYRO-Sensor, E-compass,  etc
SENSOR_TYPE="${1}"

#  sensor calibration  CMD format:  [sample_time] [sensor_select [a c g l p] ] ;
#  eg: 5 a c
#

case $SENSOR_TYPE in
  1) CONFIG="5 a c" ;
     logi "SENSOR_TYPE: ACCEL-sensor";;
  2) CONFIG="5 c c" ;
     logi "Sensor Type: MAG-Sensor";;
  3) CONFIG="5 g c" ;
     logi "Sensor Type: GYRO-Sensor";;
  4) CONFIG="5 l c" ;
     logi "Sensor Type: LIGHT-Sensor";;
  5) CONFIG="5 p c" ;
     logi "Sensor Type: PRESSURE-Sensor";;
  *) CONFIG="";
     logi "Sensor Type: Other sensors ";;
esac

for i in $(seq 1 3)
do
    if (sensors_test $CONFIG 2>&1) |tee /data/sensor_cal.log |grep '^0$'; then
        logi "Sensor calibration suceeded and update new firmware "
        break
    else
        logi "sesor cal failed, try again after 1 sec "
        sleep 1
    fi
done

exit 0
