/*
 * Decompiled with CFR 0.152.
 */
package com.qti.ims.connectionmanager;

import android.util.Log;
import com.qti.ims.connectionmanager.ConnectionManagerDeviceConfiguration;
import com.qti.ims.connectionmanager.ConnectionManagerListener;
import com.qti.ims.connectionmanager.ConnectionManagerUserConfiguration;
import com.qti.ims.connectionmanager.ConnectionNativeImpl;

public class ConnectionManagerNativeImpl {
    private static boolean libraryLoaded = false;
    private static ConnectionManagerNativeImpl singletonManager = null;
    private int mNativeContext;
    private long mNativeContextLong;

    private ConnectionManagerNativeImpl() {
    }

    public static ConnectionManagerNativeImpl startService() {
        Log.i((String)"CMJava", (String)"ConnectionManagerNativeImpl startService()");
        if (singletonManager == null) {
            Log.i((String)"CMJava", (String)"ConnectionManagerNativeImpl startService() == null");
            singletonManager = new ConnectionManagerNativeImpl();
            int status = singletonManager.startServiceNative(singletonManager);
            if (status != 0) {
                Log.e((String)"CMJava", (String)("error in starting the service " + status));
                singletonManager = null;
            }
        }
        return singletonManager;
    }

    private native int startServiceNative(Object var1);

    public native int initialize();

    public ConnectionNativeImpl createConnection(String uri) {
        Log.i((String)"CMJava", (String)"ConnectionManagerNativeImpl createConnection()");
        ConnectionNativeImpl connection = new ConnectionNativeImpl(uri);
        int status = this.createConnectionNative(connection, uri);
        if (status != 0) {
            Log.e((String)"CMJava", (String)("error in creating the connection " + status));
            connection = null;
        }
        return connection;
    }

    private native int createConnectionNative(Object var1, String var2);

    public int close() {
        singletonManager = null;
        int status = this.closeNative();
        return status;
    }

    private native int closeNative();

    public native int triggerRegistration();

    public native ConnectionManagerUserConfiguration getUserConfiguration();

    public native ConnectionManagerDeviceConfiguration getDeviceConfiguration();

    public native int addListener(ConnectionManagerListener var1);

    public native int removeListener(ConnectionManagerListener var1);

    static {
        try {
            Log.i((String)"CMJava", (String)"Loading rcscmclientjni jni library");
            System.loadLibrary("-ims-rcscmjni");
            libraryLoaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            libraryLoaded = false;
            Log.i((String)"CMJava", (String)"---ERROR in LOADING LIBRARY UnsatisfiedLinkerError EXCEPTION, JNI library is not loaded---");
        }
        catch (Exception e) {
            libraryLoaded = false;
            Log.i((String)"CMJava", (String)"---ERROR in LOADING LIBRAY EXCEPTION, JNI library is not loaded---");
        }
    }
}

